<?php
session_start();

try {
    $db = new SQLite3('./api/.db.db');
    $db->exec('CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY, username TEXT, password TEXT)');

    $log_check = $db->querySingle('SELECT username FROM users WHERE id = 1', true);
    $loggedinuser = $log_check['username'] ?? null;

    if (isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
        header('Location: dns.php');
        exit;
    }

    $numRows = $db->querySingle('SELECT COUNT(*) as count FROM users');

    if ($numRows == 0) {
        $db->exec("INSERT INTO users (id, username, password) VALUES (1, 'admin', 'admin')");
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';

        $stmt = $db->prepare('SELECT id, username, password FROM users WHERE username = :username');
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $result = $stmt->execute();
        $user = $result->fetchArray(SQLITE3_ASSOC);

        if ($user && $user['password'] === $password) {
            session_regenerate_id();
            $_SESSION['loggedin'] = true;
            $_SESSION['name'] = $username;

            header('Location: ' . ($username === 'admin' ? 'user.php' : 'dns.php'));
            exit;
        } else {
            header('Location: ./index.php');
            exit;
        }
    }
} catch (Exception $e) {
    echo "Veritabanı hatası: " . htmlspecialchars($e->getMessage());
    exit;
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="WCTV APPS.">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <title>TELA IBO 4.1</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-color: #181828;
            background-image: url("./img/binding_dark.webp");
            color: #fff;
        }
        #particles-js {
            background: #8000FF;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .footer {
            position: fixed;
            left: 0;
            bottom: 0;
            width: 100%;
            color: black;
            text-align: center;
        }
        .footer a {
            color: #000;
        }
        .footer a:hover {
            color: #2e2e2e;
        }
        .btn-group .btn {
            margin: 5px;
            width: 100%;
        }
        .btn-lg-custom {
            width: 100%;
        }
        .btn-android {
            background-color: #3DDC84;
            color: white;
        }
    </style>
</head>
<body>
<br><br>
<div class="container">
    <div class="row">
        <div class="col-lg-4 mx-md-auto">
            <div class="text-center">
                <img class="w-75 p-3" src="./img/logo.png" alt="Logo">
            </div>
            <br>
            <form method="post">
                <div class="form-group">
                    <input type="text" class="form-control form-control-lg" placeholder="Kullanıcı Adı" name="username" required autofocus>
                </div>
                <div class="form-group">
                    <input type="password" class="form-control form-control-lg" placeholder="Şifre" name="password" required>
                </div>
                <input type="submit" class="btn btn-warning btn-lg btn-block" value="Giriş Yap" name="login">
            </form>
            <br>
        </div>
    </div>
</div>

</body>
</html>
