<?php
ini_set('display_errors', 0);
include('includes/header.php');

// Caminho para o arquivo de texto
$file_path = "./ad_descriptions.txt";

// Inicializa as variáveis para armazenar o conteúdo do arquivo e a cor do texto
$file_content = "";
$text_color = "";

// Verifica se o arquivo existe antes de tentar lê-lo
if (file_exists($file_path)) {
    // Lê o conteúdo do arquivo e armazena na variável $file_content
    $file_content = file_get_contents($file_path);

    // Divide o conteúdo do arquivo em linhas
    $lines = explode("\n", $file_content);

    // Atribui o valor da cor da última linha ao $text_color
    if (count($lines) > 1) {
        $text_color = $lines[count($lines) - 1];
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Atualiza a cor do texto com base no valor enviado pelo formulário
    $text_color = $_POST["text_color"];

    // Atualiza o conteúdo do arquivo com a nova descrição e cor
    $ad_description = $_POST["ad_item"];

    if (empty($ad_description)) {
        die("Por favor, insira uma descrição de anúncio.");
    }

    // Abre o arquivo para escrita
    $file = fopen($file_path, "w");

    // Escreve a descrição e a cor no arquivo
    fwrite($file, $ad_description . "\n" . $text_color . "\n");

    // Fecha o arquivo
    fclose($file);

    echo "Sucesso<br>";
}
?>

    <div class="container mt-5">
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white text-center">
                <h2><i class="fas fa-file-image"></i> Mensagens</h2>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <!-- Input para mensagem -->
                    <div class="form-group">
                        <label for="ad_item">Adicione uma mensagem:</label>
                        <input 
                            type="text" 
                            class="form-control" 
                            name="ad_item" 
                            id="ad_item" 
                            placeholder="Exemplo: Servidor temporariamente fora do ar.">
                    </div>
                    <!-- Input para cor do texto -->
                    <div class="form-group">
                        <label for="text_color">Escolha a cor do texto:</label>
                        <input 
                            type="color" 
                            class="form-control form-control-color" 
                            name="text_color" 
                            id="text_color">
                    </div>
                    <!-- Botão de salvar -->
                    <div class="text-center">
                        <input 
                            type="submit" 
                            name="submit" 
                            value="Salvar" 
                            class="btn btn-primary btn-block">
                    </div>
                </form>
                <!-- Última mensagem -->
                <div class="mt-4">
                    <h3>Última mensagem:</h3>
                    <p class="text-muted"><?php echo $file_content; ?></p>
                </div>
            </div>
        </div>
    </div>

<?php include('includes/footer.php'); ?>
