<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
include('includes/header.php');
$dbPath = './api/.db.db';
$db = new SQLiteWrapper($dbPath);

// Check if a new theme has been selected
if(isset($_POST['theme_id'])) {
    var_dump($_POST); // Adicione esta linha para verificar os dados enviados
    $themeData = ['theme_id' => $_POST['theme_id']];
    $db->update('themes', $themeData, 'id = :id', [':id' => 1]);
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

$result = $db->select('themes', 'theme_id', 'id = 1', '');
$currentThemeId = !empty($result) ? $result[0]['theme_id'] : '1'; // Replace 'default_theme_id' with a suitable default or null

// Fetch the current theme
$currentThemeId = $db->select('themes', 'theme_id', 'id = 1', '')[0]['theme_id'];
?>

<div class="col-md-12 mx-auto">
    <div class="card-body">
        <div class="card bg-primary text-white">
            <div class="card-header card-header-warning">
                <center><h2><i class="icon icon-bullhorn"></i> Theme Settings</h2></center>
            </div>
            <div class="card-body">
                <!-- Theme Selection Form -->
                <form method="post">
                    <div class="form-group">
                        <label for="theme-selector">Select Theme:</label>
                        <select class="form-control" id="theme-selector" name="theme_id">
                            <?php for($i = 1; $i <= 26; $i++): ?>
                                <option value="<?= $i ?>" <?= $currentThemeId == $i ? 'selected' : '' ?>>
                                    Theme <?= $i ?>
                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <button class="btn btn-info" type="submit">
                        <i class="icon icon-check"></i> Update Theme
                    </button>
                </form>

                <!-- Theme Thumbnails -->
                <div class="row mt-4">
                    <?php 
                    $themeNumbers = range(1, 26); // Array with theme numbers from 1 to 26
                    foreach ($themeNumbers as $num): ?>
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                            <div class="card h-100 text-center position-relative <?= $currentThemeId == $num ? 'border-primary' : '' ?>">
                                <div class="card-body">
                                    <div class="theme-title">Theme <?= $num ?></div>
                                    <img src="img/theme_<?= $num ?>.png" 
                                         alt="Theme <?= $num ?>" 
                                         class="img-fluid rounded mb-2">
                                </div>
                                <?php if ($currentThemeId == $num): ?>
                                    <img src="img/selected.png" 
                                         alt="Selected" 
                                         class="selected-indicator">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .selected-indicator {
    position: absolute;
    bottom: 10px;
    right: 10px;
    max-width: 40px; /* Resmin boyutunu ayarlayın */
    z-index: 10; /* Resmi üstte göstermek için */
}
</style>

<?php include('includes/footer.php'); ?>
