<?php
// Remova a configuração para mostrar os erros
// ini_set('display_errors', 0);
include('includes/header.php');

// Função para obter a última opção salva
function obterUltimaOpcao()
{
    $arquivo = "./api/ultima_opcao.txt";
    if (file_exists($arquivo)) {
        return file_get_contents($arquivo);
    } else {
        return "";
    }
}

// Função para obter o rótulo da opção selecionada
function obterRotuloOpcao($opcao)
{
    switch ($opcao) {
        case 'autoads.php':
            return 'Automático';
        case 'main_movies.php':
            return 'Automático 2';
        case 'autocima.php':
            return 'Automático 3';
        case 'autop.php':
            return 'Automático 4 para banner pequeno';
             case 'autosinopsebaixo.php':
            return 'Automatico 5.';
        case 'menads.php':
            return 'Manual';
        case 'pagina.php':
            return 'Página web';
        case 'note.php':
            return 'Banner com mensagem.';
            case 'autosinopsecima.php':
            return 'Automatico 6.';
            case 'autosinopselado.php':
            return 'Automatico 7.';
    }
}

// Função para obter o link da imagem para cada opção
function obterLinkImagem($opcao)
{
    // Insira o link da imagem correspondente a cada opção
    switch ($opcao) {
        case 'autoads.php':
            return 'https://i.imgur.com/VWkonfC.jpeg';
        case 'main_movies.php':
            return 'https://i.imgur.com/2rX1U7z.jpeg';
        case 'autocima.php':
            return 'https://i.imgur.com/00JWjLa.jpeg';
        case 'autop.php':
            return 'https://i.imgur.com/n4fzoTY.jpeg';
        case 'menads.php':
            return 'https://i.imgur.com/r5bVG7s.jpeg';
        case 'pagina.php':
            return 'https://i.imgur.com/DW6Mc64.jpeg';
        case 'note.php':
            return 'https://i.imgur.com/8PWHhYe.jpeg';
        case 'autosinopsebaixo.php':
            return 'https://i.imgur.com/r2yTp8u.jpeg';
            case 'autosinopsecima.php':
            return 'https://i.imgur.com/j9NtXmf.jpeg';
            case 'autosinopselado.php':
            return 'https://i.imgur.com/d3Ax5Ba.jpeg';
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Salva a opção selecionada em um arquivo chamado "opcao.txt"
    $opcao_selecionada = $_POST["opcoes"];
    file_put_contents("./api/opcao.txt", $opcao_selecionada);

    // Salva a opção selecionada como última opção em um arquivo "ultima_opcao.txt"
    file_put_contents("./api/ultima_opcao.txt", $opcao_selecionada);

    // Se a opção selecionada for "Banner com mensagem", redireciona para mRTXinAppText.php
    if ($opcao_selecionada === 'note.php') {
        echo '<meta http-equiv="refresh" content="0; URL=mRTXinAppText.php">';
        exit; // Certifique-se de sair do script após o redirecionamento
    }
    // Se a opção selecionada for "Página web", redireciona para site.php
    elseif ($opcao_selecionada === 'pagina.php') {
        echo '<meta http-equiv="refresh" content="0; URL=site.php">';
        exit; // Certifique-se de sair do script após o redirecionamento
    }
    // Se a opção selecionada for "Manual", redireciona para fundo.php
    elseif ($opcao_selecionada === 'menads.php') {
        echo '<meta http-equiv="refresh" content="0; URL=fundo.php">';
        exit; // Certifique-se de sair do script após o redirecionamento
    }
}
?>

    <div class="row justify-content-center">
        <div class="col-md-12 mx-auto">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white text-center">
                    <h2 class="mb-0">Tipo de Banner</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="" enctype="multipart/form-data">
                        <div class="row">
                            <?php
                            $opcoes = [
                                'autoads.php' => 'Automático',
                                'main_movies.php' => 'Automático 2',
                                'autocima.php' => 'Automático 3',
                                'autop.php' => 'Automático 4 para banner pequeno',
                                'autosinopsebaixo.php' => 'Automático 5',
                                'autosinopsecima.php' => 'Automático 6',
                                'autosinopselado.php' => 'Automático 7 para ícones embaixo',
                                'note.php' => 'Banner com mensagem',
                                'menads.php' => 'Manual',
                                'pagina.php' => 'Página web'
                            ];
                            ?>
                            <?php foreach ($opcoes as $valor => $rotulo) : ?>
                                <div class="col-lg-4 col-md-6 mb-4">
                                    <div class="card h-100 border-primary text-center">
                                        <div class="card-body">
                                            <div class="form-check d-flex align-items-center justify-content-start">
                                                <input 
                                                    class="form-check-input me-2" 
                                                    type="radio" 
                                                    name="opcoes" 
                                                    id="<?php echo $valor; ?>" 
                                                    value="<?php echo $valor; ?>" 
                                                    <?php if (obterUltimaOpcao() === $valor) echo 'checked'; ?>>
                                                <label class="form-check-label" for="<?php echo $valor; ?>">
                                                    <h5 class="mt-2 mb-2"><?php echo $rotulo; ?></h5>
                                                </label>
                                            </div>
                                            <img 
                                                src="<?php echo obterLinkImagem($valor); ?>" 
                                                alt="Imagem de exemplo" 
                                                class="img-fluid rounded mt-2" 
                                                style="max-height: 150px;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="mt-4">
                            <button type="submit" name="submit" class="btn btn-primary btn-lg btn-block">Salvar</button>
                        </div>
                        <?php $ultima_opcao = obterUltimaOpcao(); ?>
                        <?php if (!empty($ultima_opcao)) : ?>
                            <p class="text-center text-success mt-3">
                                Última opção selecionada: <strong><?php echo obterRotuloOpcao($ultima_opcao); ?></strong>
                            </p>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>



<?php include('includes/footer.php'); ?>
