<?php
include('includes/header.php');

function obterUltimaOpcao()
{
    $arquivo = "./api/ultima_opcaofundo.txt";
    if (file_exists($arquivo)) {
        return file_get_contents($arquivo);
    } else {
        return "";
    }
}

function obterRotuloOpcao($opcao)
{
    switch ($opcao) {
        case 'autoads.php':
            return 'Automático';
        case 'main_movies.php':
            return 'Automático 2';
        case 'autocima.php':
            return 'Automático 3';
        case 'autop.php':
            return 'Automático 4 para banner pequeno';
             case 'autosinopsebaixo.php':
            return 'Automatico 5.';
        case 'menads.php':
            return 'Manual';
        case 'pagina.php':
            return 'Página web';
        case 'note.php':
            return 'Banner com mensagem.';
            case 'autosinopsecima.php':
            return 'Automatico 6.';
            case 'autosinopselado.php':
            return 'Automatico 7.';
    }
}

function obterLinkImagem($opcao)
{
    switch ($opcao) {
        case 'autoads.php':
            return 'https://i.imgur.com/VWkonfC.jpeg';
        case 'main_movies.php':
            return 'https://i.imgur.com/2rX1U7z.jpeg';
        case 'autocima.php':
            return 'https://i.imgur.com/00JWjLa.jpeg';
        case 'autop.php':
            return 'https://i.imgur.com/n4fzoTY.jpeg';
        case 'menads.php':
            return 'https://i.imgur.com/r5bVG7s.jpeg';
        case 'pagina.php':
            return 'https://i.imgur.com/DW6Mc64.jpeg';
        case 'note.php':
            return 'https://i.imgur.com/8PWHhYe.jpeg';
        case 'autosinopsebaixo.php':
            return 'https://i.imgur.com/r2yTp8u.jpeg';
            case 'autosinopsecima.php':
            return 'https://i.imgur.com/j9NtXmf.jpeg';
            case 'autosinopselado.php':
            return 'https://i.imgur.com/d3Ax5Ba.jpeg';
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $opcao_selecionada = $_POST["opcoes"];
    file_put_contents("./api/opcaofundo.txt", $opcao_selecionada);
    file_put_contents("./api/ultima_opcaofundo.txt", $opcao_selecionada);

    if ($opcao_selecionada === 'note.php') {
        echo '<meta http-equiv="refresh" content="0; URL=mRTXinAppText.php">';
        exit;
    }
    elseif ($opcao_selecionada === 'pagina.php') {
        echo '<meta http-equiv="refresh" content="0; URL=site.php">';
        exit;
    }
    elseif ($opcao_selecionada === 'menads.php') {
        echo '<meta http-equiv="refresh" content="0; URL=fundo.php">';
        exit;
    }
}
?>

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-primary text-white text-center">
                    <h2 class="mb-0">Tipo de Banner</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="" enctype="multipart/form-data">
                        <div class="row">
                            <?php
                            $opcoes = [
                                'autoads.php' => 'Automático.',
                                'main_movies.php' => 'Automático 2.',
                                'autocima.php' => 'Automático 3.',
                                'autop.php' => 'Automático 4 para banner pequeno.',
                                'autosinopsebaixo.php' => 'Automático 5.',
                                'autosinopsecima.php' => 'Automático 6.',
                                'autosinopselado.php' => 'Automático 7 para ícones em baixo.',
                                'note.php' => 'Banner com mensagem.',
                                'menads.php' => 'Manual.',
                                'pagina.php' => 'Página web.'
                            ];
                            ?>
                            <?php foreach ($opcoes as $valor => $rotulo) : ?>
                                <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="opcoes" id="<?php echo $valor; ?>" value="<?php echo $valor; ?>" <?php if (obterUltimaOpcao() === $valor) echo 'checked'; ?>>
                                        <label class="form-check-label d-block" for="<?php echo $valor; ?>">
                                            <strong><?php echo $rotulo; ?></strong>
                                        </label>
                                        <?php $link_imagem = obterLinkImagem($valor); ?>
                                        <img src="<?php echo $link_imagem; ?>" alt="Imagem de exemplo" class="img-fluid rounded shadow-sm mt-2">
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="text-center mt-4">
                            <button type="submit" name="submit" class="btn btn-primary btn-block">Salvar</button>
                        </div>
                        <!-- Exibe a última opção selecionada -->
                        <?php $ultima_opcao = obterUltimaOpcao(); ?>
                        <?php if (!empty($ultima_opcao)) : ?>
                            <p class="text-success text-center mt-3">
                                Última opção selecionada: <strong><?php echo obterRotuloOpcao($ultima_opcao); ?></strong>
                            </p>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<?php include('includes/footer.php'); ?>